/*
 *  util.c -- general utility functions.
 */

#include "../h/gsupport.h"
#include "globals.h"
#include "trans.h"
#include "tree.h"
#include "tcode.h"
#include "tsym.h"
#include "tproto.h"

/*
 * quit - immediate exit with error message
 */
novalue quit(msg)
char *msg;
   {
   quitf(msg,"");
   }

/*
 * quitf - immediate exit with message format and argument
 */
novalue quitf(msg,arg)
char *msg, *arg;
   {
   extern char *progname;

   fprintf(stderr,"%s: ",progname);
   fprintf(stderr,msg,arg);
   fprintf(stderr,"\n");
   exit(ErrorExit);
   }

/*
 * tsyserr is called for fatal errors.  The message s is produced and the
 *  translator exits.
 */
novalue tsyserr(s)
char *s;
   {

   if (tok_loc.n_file)
      fprintf(stderr, "File %s; ", tok_loc.n_file);
   fprintf(stderr, "Line %d # %s\n", in_line, s);
   exit(ErrorExit);
   }
